unit Main;

//     ,  
//   (override)   
//      . (  
//    .. " -  ").

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ExtCtrls;

type
  TMainForm = class(TForm)
    Image1: TImage;
    Bevel1: TBevel;
    ColorButton: TButton;
    Label1: TLabel;
    ExitButton: TButton;
    rEdit: TEdit;
    UpDown1: TUpDown;
    ColorDialog1: TColorDialog;
    RadioButton1: TRadioButton;
    RadioButton2: TRadioButton;
    Bevel2: TBevel;
    Button1: TButton;
    Label2: TLabel;
    procedure ExitButtonClick(Sender: TObject);
    procedure ColorButtonClick(Sender: TObject);
    procedure UpDown1Click(Sender: TObject; Button: TUDBtnType);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
                              Shift: TShiftState; X, Y: Integer);
    procedure FormActivate(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}

uses Figure;

const CanvasColor : TColor = clWhite; //   
var   CObj : TMyFigure;               //   

//  ,  
procedure TMainForm.ExitButtonClick(Sender: TObject);
begin
 Close;
end;

//   
procedure TMainForm.ColorButtonClick(Sender: TObject);
begin
  //   
  if ColorDialog1.Execute then
     Image1.Canvas.Pen.Color:= ColorDialog1.Color;
  if CObj <> nil then                       //   , 
     CObj.ReColor(Image1.Canvas.Pen.Color); //   
end;

//   
procedure TMainForm.UpDown1Click(Sender: TObject; Button: TUDBtnType);
begin
  if CObj <> nil then                   //   , 
     CObj.ReSize(StrToInt(rEdit.Text)); //    
end;

//   
procedure TMainForm.Image1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then //     }
  begin
    CObj.Free;            //   ,   
    //  
    if RadioButton1.Checked
    then CObj := TMyCircle.Create(Image1, X, Y, StrToInt(rEdit.Text),
                                  Image1.Canvas.Pen.Color, CanvasColor)
    else CObj := TMySquare.Create(Image1, X, Y, StrToInt(rEdit.Text),
                                  Image1.Canvas.Pen.Color, CanvasColor);
    CObj.Draw; //     
  end;
end;

//  
procedure TMainForm.FormActivate(Sender: TObject);
begin
   Image1.Canvas.Brush.Color := CanvasColor; //   
   Image1.Canvas.Pen.Color := clBlack;       //   
end;

//    Image
procedure TMainForm.Button1Click(Sender: TObject);
begin
 Image1.Canvas.Brush.Style := bsSolid;
 Image1.Canvas.Brush.Color := CanvasColor;
 Image1.Canvas.FillRect(Rect(0,0,Image1.Width, Image1.Height));
end;

//     UNIT
initialization
finalization CObj.Free; //   ,   
end.
